document.addEventListener("DOMContentLoaded", function () {
  const images = document.querySelectorAll(".slideshow img");
  let currentIndex = 0;

  function showNextImage() {
    // Remove active class from current image
    images[currentIndex].classList.remove("active");

    // Move to next image (loop back to 0 if at end)
    currentIndex = (currentIndex + 1) % images.length;

    // Add active class to new current image
    images[currentIndex].classList.add("active");
  }

  // Change image every 3 seconds
  setInterval(showNextImage, 3000);
});
